#!/bin/sh

#  install.sh
#  Red Giant Installer
#
#  Created by Christopher Corbell on 6/16/17.
#  Copyright © 2017 Red Giant. All rights reserved.
#
# This script is the command-line way to install Red Giant products.
# It must be run as sudo (will prompt for admin password from the terminal.
#
# It's designed to be run from the MacOS folder alongside rgdeploy,
# with the packages folder in the app bundle's Resources directory.

# make sure we are running in sudo mode
sudo echo

FUSEOPTION=""

SCRIPTDIR=`dirname "$0"`
PACKAGESDIR="${SCRIPTDIR}/../Resources/packages"
RGDEPLOY="${SCRIPTDIR}/../MacOS/rgdeploy"

LOGFILE="/Library/Logs/Red Giant/redgiant-installer-"`date +%s`".log"

#echo "SCRIPTDIR: ${SCRIPTDIR}"
#echo "PACKAGESDIR: ${PACKAGESDIR}"
#echo "RGDEPLOY: ${RGDEPLOY}"
echo "Running Red Giant installer tool rgdeploy"
echo "A log file for this install will be written here:"
echo "${LOGFILE}"
echo "..."
sudo "${RGDEPLOY}" --verbose ${FUSEOPTION} dir="${PACKAGESDIR}" log="${LOGFILE}" "$@"

